import { StarIO10ErrorCode } from "./StarIO10ErrorCode";
export class StarIO10Error extends Error {
    constructor(message, errorCode = StarIO10ErrorCode.None) {
        super(message);
        this.name = this.typeName;
        this.errorCode = errorCode;
    }
    errorCode;
    get typeName() {
        return "StarIO10Error";
    }
    // WebWorkerに渡すために一般エラークラスに変換する。
    /* eslint-disable @typescript-eslint/no-explicit-any */
    generalize() {
        const errorMap = {
            type: this.typeName,
            message: this.message,
            errorCode: this.errorCode,
        };
        const errorString = JSON.stringify(errorMap);
        const error = new Error(errorString);
        error.name = this.typeName;
        error.stack = this.stack; // スタックトレースを引き継ぐ
        return error;
    }
}
